/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.jei;

import com.almostreliable.summoningrituals.Setup;
import com.almostreliable.summoningrituals.compat.jei.AltarCategory;
import com.almostreliable.summoningrituals.compat.jei.ingredient.block.BlockReferenceHelper;
import com.almostreliable.summoningrituals.compat.jei.ingredient.block.BlockReferenceRenderer;
import com.almostreliable.summoningrituals.compat.jei.ingredient.mob.MobHelper;
import com.almostreliable.summoningrituals.compat.jei.ingredient.mob.MobIngredient;
import com.almostreliable.summoningrituals.compat.jei.ingredient.mob.MobRenderer;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.util.GameUtils;
import com.almostreliable.summoningrituals.util.TextUtils;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class AlmostJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return TextUtils.getRL("jei");
    }

    public void registerIngredients(IModIngredientRegistration r) {
        r.register(AlmostTypes.BLOCK_REFERENCE, List.of(), (IIngredientHelper)new BlockReferenceHelper(), (IIngredientRenderer)new BlockReferenceRenderer(16));
        r.register(AlmostTypes.MOB, List.of(), (IIngredientHelper)new MobHelper(), (IIngredientRenderer)new MobRenderer(16));
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        IGuiHelper guiHelper = r.getJeiHelpers().getGuiHelper();
        r.addRecipeCategories(new IRecipeCategory[]{new AltarCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeManager rm = GameUtils.getRecipeManager(null);
        r.addRecipes(AltarCategory.TYPE, rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)Setup.ALTAR_RECIPE.type().get()));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.ALTAR_ITEM.get()), new RecipeType[]{AltarCategory.TYPE});
        r.addRecipeCatalyst(new ItemStack((ItemLike)Setup.INDESTRUCTIBLE_ALTAR_ITEM.get()), new RecipeType[]{AltarCategory.TYPE});
    }

    public static final class AlmostTypes {
        public static final IIngredientType<BlockReference> BLOCK_REFERENCE = () -> BlockReference.class;
        public static final IIngredientType<MobIngredient> MOB = () -> MobIngredient.class;

        private AlmostTypes() {
        }
    }
}

